<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function () {
    const header = document.querySelector('.main-header-container');

    if (!header) {
        console.error('Header element not found. Ensure the class name is correct and the element exists in the DOM.');
    } else {
        const stickyClass = 'making-header-sticky';
        const hideClass = 'hide-before-after';

        window.addEventListener('scroll', function () {
            if (window.scrollY > 0) {
                if (!header.classList.contains(stickyClass)) {
                    header.classList.add(stickyClass);
                    header.classList.add(hideClass);
//                     console.log('Added sticky and hide-before-after classes to header');
                }
            } else {
                if (header.classList.contains(stickyClass)) {
                    header.classList.remove(stickyClass);
                    header.classList.remove(hideClass);
//                     console.log('Removed sticky and hide-before-after classes from header');
                }
            }
        });
    }
});</script>
<!-- end Simple Custom CSS and JS -->
