<?php
/**
 * Plugin Name: Menu with Icon
 * Description: Custom Elementor widget to display menu items with icons.
 * Version: 1.0.0
 * Author: Muhammad Qurban
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Register Custom Widget
function register_menu_with_icon_widget( $widgets_manager ) {
	require_once( __DIR__ . '/widgets/menu-with-icon-widget.php' );
	$widgets_manager->register( new \Menu_With_Icon_Widget() );
}
add_action( 'elementor/widgets/register', 'register_menu_with_icon_widget' );

// Enqueue styles and scripts
function menu_with_icon_enqueue_scripts() {
	wp_enqueue_style( 'menu-with-icon-css', plugins_url( '/assets/css/style.css', __FILE__ ) );
	wp_enqueue_script( 'menu-with-icon-js', plugins_url( '/assets/js/script.js', __FILE__ ), array( 'jquery' ), false, true );
}
add_action( 'wp_enqueue_scripts', 'menu_with_icon_enqueue_scripts' );
