<?php
  use Elementor\Group_Control_Image_Size;
  use Elementor\Icons_Manager;

  $settings = $this->get_settings_for_display();
  $skin = $settings['style'];
  $title_text = $settings['title_text'];
  $description_text = $settings['description_text'];
  $subtitle_text = $settings['subtitle_text'];
  $this->add_render_attribute( 'block', 'class', [ 'gsc-image-content', $settings['style'] ] );
  $header_tag = 'h2';
	
  $this->add_render_attribute( 'title_text', 'class', 'title' );
  $this->add_render_attribute( 'description_text', 'class', 'desc' );

  $this->add_inline_editing_attributes( 'title_text', 'none' );
  $this->add_inline_editing_attributes( 'description_text' );

?>
		
	<?php if($skin == 'skin-v1'){ ?>
		<div class="about-one__single">
				 	<?php 
				 		if( !empty($settings['image']['url']) ){
							echo '<div class="about-one__image">';
								$image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'image');
								echo $image_html;
							echo '</div>';
				 		}
				 		if( $settings['title_text'] || $settings['subtitle_text'] || $settings['description_text'] ){
				 			echo '<div class="about-one__content">';
					 			echo '<div class="about-one__content-inner">';
					 				if($settings['subtitle_text']){
					 					echo '<div class="about-one__subtitle">' . esc_html($settings['subtitle_text']) . '</div>';
					 				}
					 				if($settings['title_text']){
					 					echo '<div class="about-one__title">' . esc_html($settings['title_text']) . '</div>';
					 				}
					 				if($settings['description_text']){
					 					echo '<div class="about-one__desc">' . esc_html($settings['description_text']) . '</div>';
					 				}
					 			echo '</div>';
				 			echo '</div>';
				 		}
				 	?>	

			<?php $this->gva_render_link_overlay($settings['link']); ?>
		</div>
	<?php } ?>  
	 

	<?php if($skin == 'skin-v2'){ ?>
		<div class="about-two__single">
		  	<?php 
		  		if( !empty($settings['image']['url']) ){
				 	echo '<div class="about-two__image">';
				 		echo '<div class="content-inner">';
						  $image_url = $settings['image']['url']; 
						  $image_html = '<img src="' . esc_url($image_url) .'" alt="'. esc_attr($settings['title_text']) . '" />';
						  $this->gva_render_link_html($image_html, $settings['link']);
				 		echo '</div>';
				 		if(!empty($settings['image_logo']['url'])){
				 			echo '<div class="about-two__logo">';
				 				echo '<img src="'.esc_url($settings['image_logo']['url']).'" alt="'. esc_attr($settings['title_text']) . '" />';
				 			echo '</div>';
				 		}
				 	echo '</div>';
		  		} 
		  		if( !empty($settings['image_second']['url']) ){
				 	echo '<div class="about-two__image-second">';
						echo '<div class="content-inner">';
						 	$image_url_second = $settings['image_second']['url']; 
						 	$image_html = '<img src="' . esc_url($image_url_second) .'" alt="'. esc_attr($settings['title_text']) . '" />';
					  		$this->gva_render_link_html($image_html, $settings['link']);
						echo '</div>';
				 	echo '</div>';
			 	}
			?>
		</div>
	<?php } ?> 

	<?php if($skin == 'skin-v3'){ ?>
		<div class="about-three__single">
		  	<?php 
		  		if( !empty($settings['image']['url']) ){
				 	echo '<div class="about-three__image">';
				 		echo '<div class="content-inner">';
						  $image_url = $settings['image']['url']; 
						  $image_html = '<img src="' . esc_url($image_url) .'" alt="'. esc_attr($settings['title_text']) . '" />';
						  $this->gva_render_link_html($image_html, $settings['link']);
				 		echo '</div>';
				 	echo '</div>';
		  		} 
		  		if( !empty($settings['image_second']['url']) ){
				 	echo '<div class="about-three__image-second">';
						echo '<div class="content-inner">';
						 	$image_url_second = $settings['image_second']['url']; 
						 	$image_html = '<img src="' . esc_url($image_url_second) .'" alt="'. esc_attr($settings['title_text']) . '" />';
					  		$this->gva_render_link_html($image_html, $settings['link']);
						echo '</div>';
				 	echo '</div>';
			 	}
			?>
		</div>
	<?php } ?>

	<?php if($skin == 'skin-v4'){ ?>
		<div class="about-four__single">
			<div class="about-four__wrap">
			  	<?php 
			  		if( !empty($settings['image']['url']) ){
						 	echo '<div class="about-four__image">';
						 		echo '<div class="content-inner">';
								  $image_url = $settings['image']['url']; 
								  $image_html = '<img src="' . esc_url($image_url) .'" alt="'. esc_attr($settings['title_text']) . '" />';
								  $this->gva_render_link_html($image_html, $settings['link']);
						 		echo '</div>';
						 	echo '</div>';	
			  		}
			  		if($settings['image_second']['url']){
						 	echo '<div class="about-four__image-second">';
								echo '<div class="content-inner">';
								 	$image_url_second = $settings['image_second']['url']; 
								 	$image_html = '<img src="' . esc_url($image_url_second) .'" alt="'. esc_attr($settings['title_text']) . '" />';
							  		$this->gva_render_link_html($image_html, $settings['link']);
								echo '</div>';
							echo '</div>';
						 }			  		 
				?>
			</div>	
		</div>
	<?php } ?> 
  
<?php if($skin == 'skin-v5'){ ?>
  	<div class="about-five__single">
  		<div class="about-five__content">
		 	<?php 
		 		if(!empty($settings['image']['url'])){
					echo '<div class="about-five__image">';
						echo '<div class="about-five__image-inner">';
							$image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'image');
							echo wp_kses($image_html, true);
						echo '</div>';	
					echo '</div>';
		 		}
		 	
	 			echo '<div class="about-five__content-inner">';
					if($title_text){
						echo '<'.esc_attr($header_tag) . ' class="about-five__title">';
							echo html_entity_decode($title_text);
						echo '</'.esc_attr($header_tag).'>';
					} 
					if($description_text){
						echo '<div class="about-five__desc">' . wp_kses($description_text, true) . '</div>';
					}
				echo '</div>';

			 	$this->gva_render_link_overlay($settings['link'], 'about-five__link'); 
			?>
	 </div>  
  </div>
<?php } ?> 

  
<?php if($skin == 'skin-v6'){ ?>
  	<div class="about-six__single">
  		<div class="about-six__content">
		 	<?php 
		 		if(!empty($settings['image']['url'])){
					echo '<div class="about-six__image">';
						$image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'image');
						echo wp_kses($image_html, true);
					echo '</div>';
		 		}
			 	$this->gva_render_link_overlay($settings['link'], 'about-six__link'); 
			?>
	 </div>  
  </div>
<?php } ?> 

<?php if($skin == 'skin-v7'){ ?>
  	<div class="about-seven__single">
			<div class="about-seven__wrap">
			  	<?php 
			  		if( !empty($settings['image']['url']) ){
						 	echo '<div class="about-seven__image">';
						 		echo '<div class="content-inner">';
								  $image_url = $settings['image']['url']; 
								  $image_html = '<img src="' . esc_url($image_url) .'" alt="'. esc_attr($settings['title_text']) . '" />';
								  $this->gva_render_link_html($image_html, $settings['link']);
						 		echo '</div>';
						 	echo '</div>';	
			  		}
			  		if($settings['image_second']['url']){
						 	echo '<div class="about-seven__image-second">';
								echo '<div class="content-inner">';
								 	$image_url_second = $settings['image_second']['url']; 
								 	$image_html = '<img src="' . esc_url($image_url_second) .'" alt="'. esc_attr($settings['title_text']) . '" />';
							  		$this->gva_render_link_html($image_html, $settings['link']);
								echo '</div>';
							echo '</div>';
						 }			  		 
				?>
			</div>	
		</div>
<?php } ?> 
<?php if($skin == 'skin-v8'){ ?>
		<div class="about-eight__single">
		  	<?php 
		  		if( !empty($settings['image']['url']) ){
				 	echo '<div class="about-eight__image">';
				 		echo '<div class="content-inner">';
						  $image_url = $settings['image']['url']; 
						  $image_html = '<img src="' . esc_url($image_url) .'" alt="'. esc_attr($settings['title_text']) . '" />';
						  $this->gva_render_link_html($image_html, $settings['link']);
				 		echo '</div>';
				 	echo '</div>';
		  		} 
		  		if( !empty($settings['image_second']['url']) ){
				 	echo '<div class="about-eight__image-second">';
						echo '<div class="content-inner">';
						 	$image_url_second = $settings['image_second']['url']; 
						 	$image_html = '<img src="' . esc_url($image_url_second) .'" alt="'. esc_attr($settings['title_text']) . '" />';
					  		$this->gva_render_link_html($image_html, $settings['link']);
						echo '</div>';
				 	echo '</div>';
			 	}
			?>
		</div>
	<?php } ?>
	<?php if($skin == 'skin-v9'){ ?>
		<div class="about-nine__single">
		  	<?php 
		  		if( !empty($settings['image']['url']) ){
				 	echo '<div class="about-nine__image">';
				 		echo '<div class="content-inner">';
				 			
				 			$image_url = $settings['image']['url']; 
						  	$image_html = '<span class="about-nine__img"><img src="' . esc_url($image_url) .'" alt="'. esc_attr($settings['title_text']) . '" /></span>';
						  	$this->gva_render_link_html($image_html, $settings['link']);

				 			echo '<span class="shape-1">
				 				<svg width="967" height="896" viewBox="0 0 967 896" version="1.1" xmlns="http://www.w3.org/2000/svg">
									<g>
										<path fill="#29b79b" opacity="1.00" d=" M 248.23 0.00 L 790.17 0.00 C 846.52 97.34 902.63 194.83 958.90 292.22 C 963.52 299.92 966.18 308.67 967.00 317.60 L 967.00 323.74 C 966.49 332.74 964.01 341.65 959.47 349.45 C 884.36 479.39 809.24 609.31 734.14 739.24 C 730.27 746.39 725.52 753.23 719.10 758.33 C 719.03 759.38 718.97 760.44 718.92 761.52 C 713.35 769.61 709.01 778.51 703.88 786.90 C 690.61 809.93 677.30 832.94 664.04 855.98 C 659.10 864.23 654.95 873.21 647.73 879.80 C 637.22 889.97 622.62 895.71 608.00 895.51 C 499.67 895.48 391.34 895.51 283.01 895.49 C 266.86 895.28 250.99 887.69 240.74 875.21 C 237.31 871.19 234.73 866.56 232.14 861.98 C 160.07 737.32 88.01 612.66 15.94 488.00 C 12.69 482.24 9.20 476.60 6.10 470.76 C 2.58 464.15 0.90 456.76 0.00 449.38 L 0.00 442.37 C 0.62 433.62 3.05 424.98 7.46 417.38 C 87.66 278.22 168.12 139.21 248.23 0.00 Z" />
									</g>
								</svg>
							</span>';
							echo '<span class="shape-2"><svg width="472" height="287" viewBox="0 0 472 287" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M17.7109 277.976C22.5341 277.976 26.4441 274.066 26.4441 269.242C26.4441 264.419 22.5341 260.509 17.7109 260.509C12.8878 260.509 8.97778 264.419 8.97778 269.242C8.97778 274.066 12.8878 277.976 17.7109 277.976Z" fill="#29B79B"/>
								<path d="M453.713 0.480835C444.084 0.480835 436.238 8.31827 436.238 17.9554C436.238 23.5868 438.934 28.5961 443.08 31.7891L322.666 240.364C312.888 257.3 294.667 267.824 275.11 267.824H35.1192C34.3893 258.859 26.8754 251.776 17.7193 251.776C8.09041 251.776 0.244629 259.614 0.244629 269.251C0.244629 278.888 8.08212 286.725 17.7193 286.725C26.8754 286.725 34.3893 279.643 35.1192 270.677H275.11C295.679 270.677 314.845 259.614 325.129 241.799L445.469 33.3649C447.924 34.6836 450.735 35.4383 453.713 35.4383C463.341 35.4383 471.179 27.6008 471.179 17.9637C471.179 8.31828 463.341 0.480835 453.713 0.480835ZM17.7193 283.872C9.6496 283.872 3.08937 277.312 3.08937 269.243C3.08937 261.173 9.6496 254.613 17.7193 254.613C25.7806 254.613 32.3491 261.173 32.3491 269.243C32.3491 277.312 25.7806 283.872 17.7193 283.872ZM453.713 32.577C445.643 32.577 439.083 26.0168 439.083 17.9471C439.083 9.87746 445.643 3.31728 453.713 3.31728C461.774 3.31728 468.343 9.87746 468.343 17.9471C468.343 26.0168 461.774 32.577 453.713 32.577Z" fill="#29B79B"/>
								<path d="M453.713 26.6884C458.536 26.6884 462.446 22.7785 462.446 17.9553C462.446 13.1321 458.536 9.22217 453.713 9.22217C448.889 9.22217 444.979 13.1321 444.979 17.9553C444.979 22.7785 448.889 26.6884 453.713 26.6884Z" fill="#29B79B"/>
							</svg></span>';
							echo '<span class="shape-3"><svg width="535" height="708" viewBox="0 0 535 708" fill="none" xmlns="http://www.w3.org/2000/svg">
								<g filter="url(#filter0_f_22_7)"><circle cx="354" cy="354" r="114" fill="#29B79B" fill-opacity="0.5"/></g>
								<defs><filter id="filter0_f_22_7" x="0" y="0" width="708" height="708" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
								<feFlood flood-opacity="0" result="BackgroundImageFix"/><feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/><feGaussianBlur stdDeviation="120" result="effect1_foregroundBlur_22_7"/>
								</filter>
								</defs>
							</svg></span>';

				 		echo '</div>';
				 	echo '</div>';
		  		} 
		  		if( !empty($settings['image_second']['url']) ){
				 	echo '<div class="about-nine__image-second">';
						echo '<div class="content-inner">';
						 	$image_url_second = $settings['image_second']['url']; 
						 	$image_html = '<img src="' . esc_url($image_url_second) .'" alt="'. esc_attr($settings['title_text']) . '" />';
					  		$this->gva_render_link_html($image_html, $settings['link']);
						echo '</div>';
						if(!empty($settings['image_logo']['url'])){
				 			echo '<div class="about-nine__logo">';
				 				echo '<img src="'.esc_url($settings['image_logo']['url']).'" alt="'. esc_attr($settings['title_text']) . '" />';
				 			echo '</div>';
				 		}
				 	echo '</div>';
			 	}
			?>
		</div>
	<?php } ?>