<?php 
   global $post;

   $thumbnail = (isset($thumbnail_size) && $thumbnail_size) ? $thumbnail_size : 'post-thumbnail';
   $excerpt_words = (isset($excerpt_words) && $excerpt_words) ? $excerpt_words : '0';

   $desc = consilox_limit_words($excerpt_words, get_the_excerpt(), '');

   $meta_classes = 'post-one__meta';
   if(empty(get_the_date())){
      $meta_classes = 'post-one__meta schedule-date';
   }
   $content_classes = 'post-one__content';
   $thumbnail_check = has_post_thumbnail() ? ' has-thumbnail' : ' has-no-thumbnail';
   $content_classes .= $thumbnail_check;
?>

   <article <?php post_class('post post-one__single'); ?>>
      <?php 
         if(has_post_thumbnail()){
            echo '<div class="post-one__thumbnail">';
               echo '<a href="' . esc_url( get_permalink() ) . '">';
                  the_post_thumbnail( $thumbnail, array( 'alt' => get_the_title() ) );
               echo '</a>';
               if( get_the_date() ){
                  echo '<div class="post-one__entry-date">';
                     echo '<span class="date">' . esc_html( get_the_date('d')) . '</span>';
                     echo '<span class="month">' . esc_html( get_the_date('M')) . '</span>';
                  echo '</div>';
               } 
            echo '</div>';
         }
      ?>
       
      <div class="<?php echo esc_attr($content_classes) ?>">
         <div class="post-one__content-inner">
            <h3 class="post-one__title"><a href="<?php echo esc_url( get_permalink() ) ?>" rel="bookmark"><?php the_title() ?></a></h3>
            <div class="<?php echo esc_attr($meta_classes) ?>">
               <?php consilox_posted_on(); ?>
            </div> 
         </div>
      </div>
   </article>   

  