<?php
	if (!defined('ABSPATH')){ exit; }
	use Elementor\Icons_Manager;
	use Elementor\Group_Control_Image_Size;

	$classes = array();
   $classes[] = 'location__single';
   if($settings['active'] == 'yes') $classes[] = 'active';
	$this->add_render_attribute('wrapper', 'class', $classes);

?>

<div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
	<div class="location__wrap">
		<h3 class="location__title"><?php echo $settings['title_text'] ?></h3>
		<div class="location__content">
			<?php 
				if(!empty($settings['image']['url'])){
					echo '<div class="location__image">';
						$image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'image');
						echo $image_html;
		 			echo '</div>';
		 		}
		 		if($settings['description_text']){
		 			echo '<div class="location__desc">';
		 				echo $settings['description_text'];
					echo '</div>';
		 		}
				foreach ($settings['contact_items'] as $item){ 
					$has_icon = ! empty( $item['selected_icon']['value']); 
					echo '<div class="location__contact-item">';
						if($has_icon){ 
							echo '<div class="location__contact-icon">';
								Icons_Manager::render_icon($item['selected_icon'], [ 'aria-hidden' => 'true' ]); 
							echo '</div>';
						}
						if($item['title']){ 
							echo '<h3 class="location__contact-title">';
								$this->gva_render_link_html($item['title'], $item['link'], 'location__contact-link-overlay');
							echo '</h3>';
						}
				 		
					echo '</div>';	
				} 
			?>
		</div>	
	</div>   
</div>
