<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
jQuery(document).ready(function ($) {
   $(".overlay_background").addClass("initial_disabled")
    const blocks = $('.block'); // All blocks
    const images = $('.image-container img'); // All images
    const defaultIndex = 0; // Index of the default image
    let currentIndex = -1;

    const styles = [
        function () {
            $('.first_prog svg > *:nth-child(1)').css('stroke', '#005128');
        },
        function () {
            $('.second_prog svg > *:nth-child(1)').css('stroke', '#005128');
            $('.second_prog svg > *:nth-child(2)').css('fill', '#005128');
        },
        function () {
            $('.third_prog svg > *:nth-child(1)').css('stroke', '#005128');
            $('.third_prog svg > *:nth-child(2)').css('fill', '#005128');
        },
        function () {
            $('.fourth_prog svg > *:nth-child(1)').css('fill', '#005128');
        }
    ];

    function resetStyles(index) {
        for (let i = index + 1; i < styles.length; i++) {
            $(`.block:nth-child(${i + 1}) svg *`).css({
                stroke: '',
                fill: '',
            });
        }
    }

    function applyStylesAndShowImage(index) {
        resetStyles(index);

        // Apply styles up to the current index
        for (let i = 0; i <= index; i++) {
            styles[i]();
        }

        // Manage visibility of images
        images.removeClass('active'); // Hide all images
        if (index >= 0) {
            images.eq(index).addClass('active'); // Show the active image
        } else {
            images.eq(defaultIndex).addClass('active'); // Show the default image
        }
    }

    // Mouse enter event
    blocks.on('mouseenter', function () {
		$(".overlay_background").removeClass("initial_disabled")

        const index = blocks.index(this);
        if (index !== currentIndex) {
            currentIndex = index;
            applyStylesAndShowImage(currentIndex);
        }
    });

    // Mouse leave event
    blocks.on('mouseleave', function () {
        const index = blocks.index(this);
        if (index === currentIndex) {
            currentIndex = -1; // Reset when leaving the current block
            applyStylesAndShowImage(currentIndex); // Revert to the default state
        }
    });

    // When leaving the container, show the default image
    $('.how_it_works').on('mouseleave', function () {
        currentIndex = -1;
        applyStylesAndShowImage(currentIndex);
		$(".overlay_background").addClass("initial_disabled")


    });

    // Initial state: Show the first image
    images.eq(defaultIndex).addClass('active');

});
</script>
<!-- end Simple Custom CSS and JS -->
