<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );
         
if ( !function_exists( 'child_theme_configurator_css' ) ):
    function child_theme_configurator_css() {
        wp_enqueue_style( 'chld_thm_cfg_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'iconoir','line-awesome','bootstrap','swiper-bundle','synck-style','synck-unit','synck-responsive' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'child_theme_configurator_css', 10 );

// END ENQUEUE PARENT ACTION
function blog_grid_shortcode($atts) {
    // Parse shortcode attributes
    $atts = shortcode_atts(array(
        'posts_per_page' => 6,
        'category' => '',
        'order' => 'DESC',
        'orderby' => 'date'
    ), $atts);

    // Query posts
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'order' => $atts['order'],
        'orderby' => $atts['orderby'],
        'post_status' => 'publish'
    );

    if (!empty($atts['category'])) {
        $args['category_name'] = $atts['category'];
    }

    $query = new WP_Query($args);
    
    if (!$query->have_posts()) {
        return '<p>No posts found.</p>';
    }

    ob_start();
    ?>
    
    <style>
    .blog-grid-container {
    display: grid;
    grid-template-columns: 1fr; /* Default: 1 column for <600px */
    gap: 30px;
    margin: 40px 0;
    max-width: 1200px;
}

@media (min-width: 600px) {
    .blog-grid-container {
        grid-template-columns: repeat(2, 1fr); /* 2 columns from 600px to 768px */
    }
}

@media (min-width: 769px) {
    .blog-grid-container {
        grid-template-columns: repeat(3, 1fr); /* 3 columns above 768px */
    }
}
    .blog-card {
        background: #ffffff;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        display: flex;
        flex-direction: column;
        height: 100%;
    }
    
    .blog-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
    }
    
    .blog-card-image {
        width: 100%;
        height: 200px;
        overflow: hidden;
        position: relative;
    }
    
    .blog-card-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.3s ease;
    }
    
    .blog-card:hover .blog-card-image img {
        transform: scale(1.05);
    }
    
    .blog-card-content {
        padding: 24px;
        flex-grow: 1;
        display: flex;
        flex-direction: column;
    }
    
    .blog-card-meta {
        display: flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 16px;
        font-size: 14px;
        color: #2563eb;
        font-weight: 500;
    }
    
    .blog-card-meta .separator {
        color: #6b7280;
    }
    
    .blog-card-title {
        font-size: 18px;
        font-weight: 700;
        color: #1f2937;
        margin-bottom: 12px;
        line-height: 1.4;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .blog-card-excerpt {
        color: #4b5563;
        line-height: 1.6;
        margin-bottom: 20px;
        flex-grow: 1;
        font-size: 14px;
    }
    
    .blog-card-button {
        background: #2563eb;
        color: white;
        padding: 12px 24px;
        border-radius: 25px;
        text-decoration: none;
        font-weight: 600;
        font-size: 14px;
        display: inline-block;
        align-self: flex-start;
        transition: background-color 0.3s ease, transform 0.2s ease;
    }
    
    .blog-card-button:hover {
        background: #1d4ed8;
        transform: translateY(-1px);
        color: white;
        text-decoration: none;
    }
    
    .blog-card-button:focus {
        outline: none;
        box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.3);
    }
    </style>
    
    <div class="blog-grid-container">
        <?php while ($query->have_posts()) : $query->the_post(); ?>
            <article class="blog-card">
                <div class="blog-card-image">
                    <?php if (has_post_thumbnail()) : ?>
                        <a href="<?php the_permalink(); ?>">
                            <?php the_post_thumbnail('medium_large', array('alt' => get_the_title())); ?>
                        </a>
                    <?php else : ?>
                        <a href="<?php the_permalink(); ?>">
                            <img src="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='400' height='200' viewBox='0 0 400 200'%3E%3Crect width='400' height='200' fill='%23f3f4f6'/%3E%3Ctext x='50%25' y='50%25' font-family='Arial, sans-serif' font-size='14' fill='%236b7280' text-anchor='middle' dy='.3em'%3ENo Image%3C/text%3E%3C/svg%3E" alt="<?php the_title(); ?>">
                        </a>
                    <?php endif; ?>
                </div>
                
                <div class="blog-card-content">
                    <div class="blog-card-meta">
                        <span><?php echo get_the_date('F j, Y'); ?></span>
                        <span class="separator">–</span>
                        <span>
                            <?php 
                            $categories = get_the_category();
                            if (!empty($categories)) {
                                echo esc_html($categories[0]->name);
                            } else {
                                echo 'Uncategorized';
                            }
                            ?>
                        </span>
                    </div>
                    
                    <h3 class="blog-card-title">
                        <a href="<?php the_permalink(); ?>" style="color: inherit; text-decoration: none;">
                            <?php the_title(); ?>
                        </a>
                    </h3>
                    
                    <div class="blog-card-excerpt">
                        <?php 
                        $excerpt = get_the_excerpt();
                        echo wp_trim_words($excerpt, 20, ' [...]');
                        ?>
                    </div>
                    
                    <a href="<?php the_permalink(); ?>" class="blog-card-button">
                        Read More
                    </a>
                </div>
            </article>
        <?php endwhile; ?>
    </div>
    
    <?php
    wp_reset_postdata();
    return ob_get_clean();
}

// Register the shortcode
add_shortcode('blog_grid', 'blog_grid_shortcode');

// Usage examples:
// [blog_grid] - Shows 6 latest posts
// [blog_grid posts_per_page="9"] - Shows 9 posts
// [blog_grid category="technology"] - Shows posts from technology category
// [blog_grid posts_per_page="12" category="news" order="ASC"] - Custom parameters