<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Menu_With_Icon_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'menu_with_icon';
	}

	public function get_title() {
		return __( 'Menu with Icon', 'plugin-name' );
	}

	public function get_icon() {
		return 'eicon-menu-bar';
	}

	public function get_categories() {
		return [ 'general' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'menu_section',
			[
				'label' => __( 'Menu', 'plugin-name' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		// Fetch available menus
		$menus = wp_get_nav_menus();
		$menu_options = [];
		foreach ( $menus as $menu ) {
			$menu_options[ $menu->term_id ] = $menu->name;
		}

		$this->add_control(
			'select_menu',
			[
				'label' => __( 'Select Menu', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $menu_options,
				'default' => array_keys( $menu_options )[0],
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'menu_item_id',
			[
				'label' => __( 'Menu Item ID', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'menu_item_icon',
			[
				'label' => __( 'Icon', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'menu_items',
			[
				'label' => __( 'Menu Item Icons', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => __( 'Menu Item ID: {{{ menu_item_id }}}', 'plugin-name' ),
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$menu_id = $settings['select_menu'];
		$menu_items = wp_get_nav_menu_items( $menu_id );
		$icons = [];

		foreach ( $settings['menu_items'] as $item ) {
			$icons[$item['menu_item_id']] = $item['menu_item_icon']['url'];
		}

		if ( ! empty( $menu_items ) ) {
			echo '<div class="menu-with-icon">';
			foreach ( $menu_items as $menu_item ) {
				$icon_url = isset( $icons[$menu_item->ID] ) ? $icons[$menu_item->ID] : '';
				echo '<div class="menu-item">';
				if ( $icon_url ) {
					echo '<img src="' . esc_url( $icon_url ) . '" alt="' . esc_attr( $menu_item->title ) . '">';
				}
				echo '<a href="' . esc_url( $menu_item->url ) . '">' . esc_html( $menu_item->title ) . '</a>';
				echo '</div>';
			}
			echo '</div>';
		}
	}

	protected function _content_template() {
		?>
		<# if ( settings.menu_items.length ) { #>
			<div class="menu-with-icon">
				<# _.each( settings.menu_items, function( item ) { #>
					<div class="menu-item">
						<# if ( item.menu_item_icon.url ) { #>
							<img src="{{ item.menu_item_icon.url }}" alt="{{ item.menu_item_text }}">
						<# } #>
						<a href="{{ item.menu_item_link.url }}">{{{ item.menu_item_text }}}</a>
					</div>
				<# }); #>
			</div>
		<# } #>
		<?php
	}
}
