<?php 
	use Elementor\Group_Control_Image_Size;

	$style = $settings['style'];
	$image_id = isset($item['image']['id']) && $item['image']['id'] ? $item['image']['id'] : 0; 
	$image_url = isset($item['image']['url']) && $item['image']['url'] ? $item['image']['url'] : '';
	$image_alt = $item['name'];
	if($image_id){
		$attach_url = wp_get_attachment_image_src( $image_id, $settings['image_size']);
		if(isset($attach_url[0]) && $attach_url[0]){
			$image_url = $attach_url[0];
		}
		$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', TRUE);
	}
	$name = $item['name'];
	
	$image = '<img src="' . esc_url($image_url) . '" alt="' . esc_html($image_alt) . '" />';

?>

<?php if($style == 'style-1'){ ?>
	<div class="team-one__single">
		<div class="team-one__wrap">
			<?php echo $this->gva_render_link_overlay($item['link'], 'team-one__link-overlay'); ?>
			<?php if($image_url){ ?>
				<div class="team-one__image">
					<div class="team-one__line">
                        <svg viewBox="0 0 270 308" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M120.101 5.29821C129.304 -0.0872133 140.696 -0.0872197 149.899 5.2982L254.899 66.7426C263.942 72.0345 269.5 81.7259 269.5 92.2036V215.796C269.5 226.274 263.942 235.965 254.899 241.257L149.899 302.702C140.696 308.087 129.304 308.087 120.101 302.702L15.1007 241.257C6.05759 235.965 0.5 226.274 0.5 215.796V92.2036C0.5 81.7259 6.05758 72.0345 15.1006 66.7426L120.101 5.29821Z" stroke="#29B79B"/>';
                        </svg>
                    </div>
					<div class="team-one__image-inner">
						<?php echo $this->gva_render_link_html($image, $item['link'], 'link-content') ?>  
					</div>
				</div>
			<?php } ?>  
			<div class="team-one__content">
				<div class="team-one__meta">
					<?php if($item['name']){ ?>
						<h3 class="team-one__name">
							<?php echo $this->gva_render_link_html($item['name'], $item['link']) ?>   
						</h3>
					<?php } ?>

					<?php if($item['position']){ ?>
						<div class="team-one__job"><?php echo $item['position'] ?></div>
					<?php } ?>
				</div>
				<?php if($item['desc']){ ?>
					<div class="team-one__desc"><?php echo $item['desc'] ?></div>
				<?php } ?>
				<div class="team-one__socials">
					<?php $this->gva_render_link_html_2('<i class="fa fa-facebook"></i>', $item['facebook']) ?>
					<?php $this->gva_render_link_html_2('<i class="fab fa-x-twitter"></i>', $item['twitter']) ?>
					<?php $this->gva_render_link_html_2('<i class="fa fa-instagram"></i>', $item['instagram']) ?>
					<?php $this->gva_render_link_html_2('<i class="fa fa-pinterest"></i>', $item['pinterest']) ?>
				</div>  
			</div>
		</div>
	</div>
			
<?php } ?>

<?php if($style == 'style-2'){ ?>
	<div class="team-two__single elementor-repeater-item-<?php echo $item['_id'] ?>">
		<div class="team-two__content">
			<div class="team-two__meta">
				<?php 
					if($item['name']){ 
						echo '<h3 class="team-two__name">';
							echo $this->gva_render_link_html($item['name'], $item['link']);
						echo '</h3>';
					} 
					if($item['position']){
						echo '<div class="team-two__job">' . $item['position'] . '</div>';
					} 
				?>
			</div>
			<?php 
				if($image_url){ 
					echo '<div class="team-two__image">';
						echo '<div class="team-two__line">';
                            echo '<svg viewBox="0 0 270 308" fill="none" xmlns="http://www.w3.org/2000/svg">';
                                echo '<path d="M120.101 5.29821C129.304 -0.0872133 140.696 -0.0872197 149.899 5.2982L254.899 66.7426C263.942 72.0345 269.5 81.7259 269.5 92.2036V215.796C269.5 226.274 263.942 235.965 254.899 241.257L149.899 302.702C140.696 308.087 129.304 308.087 120.101 302.702L15.1007 241.257C6.05759 235.965 0.5 226.274 0.5 215.796V92.2036C0.5 81.7259 6.05758 72.0345 15.1006 66.7426L120.101 5.29821Z" stroke="#29B79B"/>';
                            echo '</svg>';
                        echo '</div>';
						echo '<div class="team-two__image-inner">';
							echo $this->gva_render_link_html($image, $item['link'], 'link-content'); 
						echo '</div>';
						echo '<div class="team-two__socials">';
							$this->gva_render_link_html_2('<i class="fa fa-facebook"></i>', $item['facebook']);
							$this->gva_render_link_html_2('<i class="fab fa-x-twitter"></i>', $item['twitter']);
							$this->gva_render_link_html_2('<i class="fa fa-instagram"></i>', $item['instagram']);
							$this->gva_render_link_html_2('<i class="fa fa-pinterest"></i>', $item['pinterest']);
						echo '</div>';
				 	echo '</div>';
				} 
			?>	  
		</div>
		<?php echo $this->gva_render_link_overlay($item['link'], 'team-two__link-overlay'); ?>
	</div>  
<?php } ?>
<?php if($style == 'style-3'){ ?>
	<div class="team-three__single elementor-repeater-item-<?php echo $item['_id'] ?>">
		<div class="team-three__wrap">
			<?php 
				if($image_url){ 
					echo '<div class="team-three__image">';
						echo '<div class="team-three__image-inner">';
							echo $this->gva_render_link_html($image, $item['link'], 'link-content'); 
						echo '</div>';
						
				 	echo '</div>';
				} 
			?>
			<div class="team-three__content">
				<div class="team-three__content-inner">
					<div class="team-three__information">
						<?php 
							if($item['name']){ 
								echo '<h3 class="team-three__name">';
									echo $this->gva_render_link_html($item['name'], $item['link']);
								echo '</h3>';
							} 
							if($item['position']){
								echo '<div class="team-three__job">' . $item['position'] . '</div>';
							} 
						?>
					</div>
					<?php echo '<div class="team-three__socials">';
						$this->gva_render_link_html_2('<i class="fa fa-facebook"></i>', $item['facebook']);
						$this->gva_render_link_html_2('<i class="fab fa-x-twitter"></i>', $item['twitter']);
						$this->gva_render_link_html_2('<i class="fa fa-instagram"></i>', $item['instagram']);
						$this->gva_render_link_html_2('<i class="fa fa-pinterest"></i>', $item['pinterest']);
					echo '</div>';
					?>
				</div>
			</div>	  
		</div>
		<?php echo $this->gva_render_link_overlay($item['link'], 'team-three__link-overlay'); ?>
	</div>  
<?php } ?>