<?php
if(!defined('ABSPATH')){ exit; }

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
class GVAElement_Location extends GVAElement_Base {
	const NAME = 'gva-location';
	const TEMPLATE = 'general/location';
	const CATEGORY = 'consilox_general';

   public function get_categories() {
		return array(self::CATEGORY);
	}

	public function get_name() {
		return self::NAME;
	}

	public function get_title() {
		return __( 'Location', 'consilox-themer' );
	}
	
	public function get_keywords() {
		return [ 'location', 'content' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'consilox-themer' ),
			]
		);
		$this->add_control(
			'style',
			[
				'label' => __( 'Style', 'consilox-themer' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style-1' => esc_html__('Style 01', 'consilox-themer'),
				],
				'default' => 'style-1',
			]
		);
		$this->add_control(
			'title_text',
			[
				'label' 			=> __( 'Title', 'consilox-themer' ),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> __( 'Enter your title', 'consilox-themer' ),
				'default' 		=> __( 'New York office', 'consilox-themer' ),
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'description_text',
			[
				'label' 			=> __( 'Description', 'consilox-themer' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'placeholder' 	=> __( 'Enter Your Description', 'consilox-themer' ),
				'default'		=> __('85 Ketch Harbour Road BensalPA 19020', 'consilox-themer')
			]
		);
		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'consilox-themer' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => GAVIAS_CONSILOX_PLUGIN_URL . 'elementor/assets/images/image-1.jpg',
				],
			]
		);

		$this->add_group_control(
         Elementor\Group_Control_Image_Size::get_type(),
         [
            'name'      => 'image',
            'default'   => 'full',
            'separator' => 'none',
         ]
      );

		$repeater = new Repeater();
		$repeater->add_control(
			'selected_icon',
			[
				'label'      	=> esc_html__('Choose Icon', 'consilox-themer'),
				'type'       	=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'icon-consilox-strategy',
					'library' 	=> 'consilox-icons-theme'
				]
			]
		);
		$repeater->add_control(
			'title',
			[
				'label'       => esc_html__('Title', 'consilox-themer'),
				'type'        => Controls_Manager::TEXT,
				'default'     => 'Add your title',
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'link',
			[
				'label'     	=> esc_html__('Link', 'consilox-themer'),
				'type'      	=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__('https://your-link.com', 'consilox-themer'),
				'label_block' 	=> true
			]
		);

		$this->add_control(
			'contact_items',
			[
				'label'       => esc_html__('Contact Item', 'consilox-themer'),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
				'default'     => array(
					array(
						'title'  					=> esc_html__('contact@example.com', 'consilox-themer'),
						'selected_icon' 			=> array('value' => 'cicon-paper-plane'),
					),
					array(
						'title'  					=> esc_html__('+(91) 5698 0036', 'consilox-themer'),
						'selected_icon' 			=> array('value' => 'cicon-telephone-1'),
					),
				)
			]
		);

		$this->add_control(
			'active',
			[
				'label' => __( 'Active', 'consilox-themer' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no'
			]
		);
		
		$this->end_controls_section();

		// Title Style
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => __( 'Title', 'consilox-themer' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Text Color', 'consilox-themer' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .about-one__title, {{WRAPPER}} .about-two__title, {{WRAPPER}} .about-five__title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'selector' => '{WRAPPER}} .about-one__title, {{WRAPPER}} .about-two__title, {{WRAPPER}} .about-five__title',
			]
		);

		$this->end_controls_section();

		// Description Style
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => __( 'Description', 'consilox-themer' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'content_color',
			[
				'label' => __( 'Text Color', 'consilox-themer' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-one__desc, {{WRAPPER}} .about-two__desc, {{WRAPPER}} .about-five__desc' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography_desc',
				'selector' => '{{WRAPPER}} .about-one__desc, {{WRAPPER}} .about-two__desc, {{WRAPPER}} .about-five__desc',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
      printf( '<div class="gva-element-%s gva-element">', $this->get_name() );
         include $this->get_template(self::TEMPLATE . '.php');
      print '</div>';
	}

}

 $widgets_manager->register(new GVAElement_Location());
