<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
jQuery(document).ready(function ($) {
	$(".overlay_background").addClass("initial_disabled")
    const blocks = $('.block'); // All blocks
    const images = ['.first_image', '.second_image', '.third_image', '.fourth_image']; // Image selectors
  
    // Define the styles for each block
    const styles = [
      function () {
        $('.first_prog svg > *:nth-child(1)').css('stroke', '#005128');
      },
      function () {
        $('.second_prog svg > *:nth-child(1)').css('stroke', '#005128');
        $('.second_prog svg > *:nth-child(2)').css('fill', '#005128');
      },
      function () {
        $('.third_prog svg > *:nth-child(1)').css('stroke', '#005128');
        $('.third_prog svg > *:nth-child(2)').css('fill', '#005128');
      },
      function () {
        $('.fourth_prog svg > *:nth-child(1)').css('fill', '#005128');
      }
    ];
  
    let currentIndex = -1;
  
    function resetStyles(index) {
      // Reset styles for all blocks above the current one
      for (let i = index + 1; i < styles.length; i++) {
        // Reset styles for the block we moved from
        if (i === 0) {
          $('.first_prog svg > *:nth-child(1)').css('stroke', '');
        } else if (i === 1) {
          $('.second_prog svg > *:nth-child(1)').css('stroke', '');
          $('.second_prog svg > *:nth-child(2)').css('fill', '');
        } else if (i === 2) {
          $('.third_prog svg > *:nth-child(1)').css('stroke', '');
          $('.third_prog svg > *:nth-child(2)').css('fill', '');
        } else if (i === 3) {
          $('.fourth_prog svg > *:nth-child(1)').css('fill', '');
        }
      }
    }
  
    function applyStylesAndShowImage(index) {
      // Reset styles for the blocks above the current one
      resetStyles(index);
  	$(".overlay_background").removeClass("initial_disabled")
      // Apply styles for all blocks up to the current one
      for (let i = 0; i <= index; i++) {
        styles[i](); // Apply styles progressively for blocks 1 to index
      }
  
      // Manage image visibility using display: none and block with transitions
      images.forEach((imgClass, i) => {
        if (i === index) {
          $(imgClass).css({
            'display': 'block',
            'opacity': 1
          }).stop().animate({ opacity: 1 }, 300); // Smooth transition
        } else {
          $(imgClass).css({
            'display': 'none',
            'opacity': 0
          });
        }
      });
    }
  
    // Mouse enter event - When the user hovers over the block
    blocks.on('mouseenter', function () {
      const index = blocks.index(this);
      if (index !== currentIndex) {
        currentIndex = index;
        applyStylesAndShowImage(currentIndex);
      }
    });
  
    // Mouse leave event - When the user leaves the block
    blocks.on('mouseleave', function () {
      const index = blocks.index(this);
      if (index === currentIndex) {
        currentIndex = -1; // Reset when leaving the current block
        applyStylesAndShowImage(currentIndex); // Revert all styles and show the first image
      }
    });
  
    // Trigger the first block's styles on page load if needed
//     applyStylesAndShowImage(0); // Optional if you want to apply styles immediately on load

    // Ensure the first image is always visible when no block is hovered
    $(window).on('mouseleave', function() {
      // When the mouse leaves the entire window (not over any blocks), keep the first image visible
      if (currentIndex === -1) {
		$(".overlay_background").addClass("initial_disabled")
        $('.first_image').css({
          'display': 'block',
          'opacity': 1
        }).stop().animate({ opacity: 1 }, 300); // Smooth transition
      }
    });
});
</script>
<!-- end Simple Custom CSS and JS -->
