<?php 
   if(!isset($index)){
      $index = 2;
   }
   $thumbnail = (isset($thumbnail_size) && $thumbnail_size) ? $thumbnail_size : 'consilox_medium';
   if(!isset($excerpt_words)){
      $excerpt_words = consilox_get_option('blog_excerpt_limit', 20);
   }
?>

<article id="post-<?php echo esc_attr(get_the_ID()); ?>" class="post post-six__single">
   <div class="post-six__thumbnail">
      <a href="<?php echo esc_url( get_permalink() ) ?>">
         <?php the_post_thumbnail( $thumbnail, array( 'alt' => get_the_title() ) ); ?>
      </a>
   </div>
   <div class="post-six__content">
      <div class="post-six__meta">
         <?php consilox_posted_on(); ?>
      </div> 
      <h2 class="post-six__title"><a href="<?php echo esc_url( get_permalink() ) ?>" rel="bookmark"><?php the_title() ?></a></h2>
      <div class="post-six__entry-date">
         <span class="date"><?php echo esc_html( get_the_date('d')) ?></span>
         <span class="month"><?php echo esc_html( get_the_date('M')) ?></span>
      </div>
   </div>
</article> 

  